//   This trigger allows mappers to change some of the zone properties using a trigger.
//   The specific case this class was written for was to enable a switchable "escalator"
//   zone to be created, where the escalator could move in two directions at once.
//
//   The Zone property changer is a one way assignment of values.  It will change the
//   properties of its target zone once.  In order to revert them back to their original
//   values an additional Zone property changer object would be required (possibly triggered
//   by a round robin trigger).
//
//   Version By  Description
//   ------- --- -------------------------------------------------------------------------
//   1.00    DML Created for Pitboy from the UT Editing fourm.
class TriggeredZonePropertyChanger extends Actor;

var ZoneInfo     zoneObject;
var() name   TargetZoneTag;

var(ZoneData) vector zZoneGravity;
var(ZoneData) vector zZoneVelocity;
var(ZoneData) float  zZoneGroundFriction;
var(ZoneData) float  zZoneFluidFriction;
var(ZoneData) float  zZoneTerminalVelocity;
var(ZoneData) name   zZonePlayerEvent;
var(ZoneData) int    zDamagePerSec;
var(ZoneData) name   zDamageType;
var(ZoneData) localized string zDamageString;
var(ZoneData) localized string zZoneName;

var(ZoneFlags) bool   zbNeutralZone;
var(ZoneFlags) bool   zbGravityZone;
var(ZoneFlags) bool   zbPainZone;
var(ZoneFlags) bool   zbDestructive;
var(ZoneFlags) bool   zbNoInventory;
var(ZoneFlags) bool   zbMoveProjectiles;
var(ZoneFlags) bool   zbBounceVelocity;

var(ZoneLight) byte zAmbientBrightness, zAmbientHue, zAmbientSaturation;
var(ZoneLight) color zFogColor;
var(ZoneLight) float zFogDistance;
var(ZoneLight) float zTexUPanSpeed, zTexVPanSpeed;
var(ZoneLight) vector zViewFlash, zViewFog;

/*
   This function is called when the event used to trigger the zone property change occurs.
   It is responsible for setting the zone properties of the target zone to the values itself
   holds.
   The Tag property of the target ZoneInfo object to update must be specified within the
   TargetZoneTag property of this object.
*/
function ZoneInfo getTargetZone()
{
	local ZoneInfo zone;

	if (zoneObject == None)
	{
		foreach AllActors( class 'ZoneInfo', zone, TargetZoneTag )
			zoneObject = zone;
	}
	return zoneObject;
}

/*
   This is the main Trigger function - it is called whenever the actor is triggered by an
   event.  It simply assigns the properties associated with this object directly to the
   ZoneInfo it points at.
*/
event Trigger( Actor Other, Pawn EventInstigator )
{
	local ZoneInfo zone;
    zone = self.getTargetZone();

	if ( zone != None )
	{
		zone.ZoneGravity = self.zZoneGravity;
		zone.ZoneVelocity = self.zZoneVelocity;
		zone.ZoneGroundFriction = self.zZoneGroundFriction;
		zone.ZoneFluidFriction = self.zZoneFluidFriction;
		zone.ZoneTerminalVelocity = self.zZoneTerminalVelocity;
		zone.ZonePlayerEvent = self.zZonePlayerEvent;
		zone.DamagePerSec = self.zDamagePerSec;
		zone.DamageType = self.zDamageType;
		zone.DamageString = self.zDamageString;
		zone.ZoneName = self.zZoneName;

		zone.bNeutralZone = self.zbNeutralZone;
		zone.bGravityZone = self.zbGravityZone;
		zone.bPainZone = self.zbPainZone;
		zone.bDestructive = self.zbDestructive;
		zone.bNoInventory = self.zbNoInventory;
		zone.bMoveProjectiles = self.zbMoveProjectiles;
		zone.bBounceVelocity = self.zbBounceVelocity;

		zone.AmbientBrightness = self.zAmbientBrightness;
		zone.AmbientHue = self.zAmbientHue;
		zone.AmbientSaturation = self.zAmbientSaturation;
		zone.FogColor = self.zFogColor;
		zone.FogDistance = self.zFogDistance;
		zone.TexUPanSpeed = self.zTexUPanSpeed;
		zone.TexVPanSpeed = self.zTexVPanSpeed;
		zone.ViewFlash = self.zViewFlash;
		zone.ViewFog = self.zViewFog;
	}
}

defaultproperties
{
     zZoneGravity=(Z=-950.000000)
     zZoneGroundFriction=8.000000
     zZoneFluidFriction=1.200000
     zZoneTerminalVelocity=2500.000000
     zbMoveProjectiles=True
     zAmbientSaturation=255
     zTexUPanSpeed=1.000000
     zTexVPanSpeed=1.000000
     bHidden=true
}
